/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.AgentContainer;
import jade.core.Filter;
import jade.core.VerticalCommand;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessagingService;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.LEAPACLCodec;
import jade.util.leap.Iterator;
import jade.util.leap.Map;
import java.util.Date;

public class OutgoingEncodingFilter
extends Filter {
    private Map messageEncodings;
    private AgentContainer myAgentContainer;
    private MessagingService myService;

    public OutgoingEncodingFilter(Map m, AgentContainer ac, MessagingService ms) {
        this.messageEncodings = m;
        this.myAgentContainer = ac;
        this.myService = ms;
        this.setPreferredPosition(10);
    }

    public boolean accept(VerticalCommand cmd) {
        block7: {
            String name = cmd.getName();
            Object[] params = cmd.getParams();
            if (!name.equals("Send-Message")) break block7;
            GenericMessage gmsg = (GenericMessage)params[1];
            AID sender = (AID)params[0];
            AID receiver = (AID)params[2];
            ACLMessage msg = gmsg.getACLMessage();
            try {
                if (msg.getSender().getName().length() < 1) {
                    msg.setSender(sender);
                }
            }
            catch (NullPointerException e) {
                msg.setSender(sender);
            }
            if (this.myAgentContainer.acquireLocalAgent(receiver) != null) {
                this.myAgentContainer.releaseLocalAgent(receiver);
                return true;
            }
            this.prepareEnvelope(msg, receiver, gmsg);
            try {
                byte[] payload = this.encodeMessage(msg);
                Envelope env = msg.getEnvelope();
                if (env != null) {
                    env.setPayloadLength(new Long(payload.length));
                }
                ((GenericMessage)cmd.getParams()[1]).update(msg, env, payload);
            }
            catch (MessagingService.UnknownACLEncodingException ee) {
                ee.printStackTrace();
            }
        }
        return true;
    }

    public void prepareEnvelope(ACLMessage msg, AID receiver, GenericMessage gmsg) {
        Date d;
        AID from;
        Iterator itTo;
        Envelope env = msg.getEnvelope();
        String defaultRepresentation = null;
        if (this.myService.livesHere(receiver)) {
            if (env == null) {
                return;
            }
            defaultRepresentation = LEAPACLCodec.NAME;
        } else {
            gmsg.setForeignReceiver(true);
            if (env == null) {
                msg.setDefaultEnvelope();
                env = msg.getEnvelope();
            } else {
                defaultRepresentation = "fipa.acl.rep.string.std";
            }
        }
        String rep = env.getAclRepresentation();
        if (rep == null) {
            env.setAclRepresentation(defaultRepresentation);
        }
        if (!(itTo = env.getAllTo()).hasNext()) {
            Iterator itReceiver = msg.getAllReceiver();
            while (itReceiver.hasNext()) {
                env.addTo((AID)itReceiver.next());
            }
        }
        if ((from = env.getFrom()) == null) {
            env.setFrom(msg.getSender());
        }
        if ((d = env.getDate()) == null) {
            env.setDate(new Date());
        }
        env.clearAllIntendedReceiver();
        env.addIntendedReceiver(receiver);
        Long payloadLength = env.getPayloadLength();
        if (payloadLength == null) {
            env.setPayloadLength(new Long(-1L));
        }
    }

    public byte[] encodeMessage(ACLMessage msg) throws MessagingService.UnknownACLEncodingException {
        String enc;
        Envelope env = msg.getEnvelope();
        String string = enc = env != null ? env.getAclRepresentation() : LEAPACLCodec.NAME;
        if (enc != null) {
            ACLCodec codec = (ACLCodec)this.messageEncodings.get(enc.toLowerCase());
            if (codec != null) {
                String charset;
                if (env == null || (charset = env.getPayloadEncoding()) == null) {
                    charset = "US-ASCII";
                }
                return codec.encode(msg, charset);
            }
            throw new MessagingService.UnknownACLEncodingException("Unknown ACL encoding: " + enc + ".");
        }
        throw new MessagingService.UnknownACLEncodingException("No ACL encoding set.");
    }
}

